<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Shipping extends Model 
{

    protected $table = 'shipping_addresses';
    public $timestamps = true;
    protected $fillable = array('shipping_nickname', 'shipping_address', 'shipping_street', 'shipping_street_additional', 'shipping_city', 'shipping_state', 'shipping_country', 'shipping_zipcode', 'shipping_latitude', 'shipping_longitude');
    protected $visible = array('shipping_nickname', 'shipping_address', 'shipping_street', 'shipping_street_additional', 'shipping_city', 'shipping_state', 'shipping_country', 'shipping_zipcode', 'shipping_latitude', 'shipping_longitude');

    public function user()
    {
        return $this->belongsTo('App\Models\User');
    }

}